<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:d='http://www.lotus.com/dxl' >
<xsl:output indent="yes" method="text" omit-xml-declaration="yes" media-type="text/lotuscript" xml:space="preserve" />
    <xsl:variable name="formName">
        <!-- We use the form alias if we have one -->
        <xsl:choose>
            <xsl:when test="/d:form/@alias=''"><xsl:value-of select="/d:form/@name"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="/d:form/@alias"/></xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <xsl:template match="/">
        <!-- We use the build-in data type mapping for LotusScript agents -->
        %INCLUDE "lsxsd.lss"
        
        '/**
        '*  Autogenerated code to be embedded into a Domino Web Service
        '*  (CC) 2007, Stephan H. Wissel --- Some rights reserved
        '*
        '*
        '*
        '**/
        
        Public Class form<xsl:value-of select="$formName"/>
            
            '/**
            '* createData takes in the custom form data and creates a new document.
            '* the data given as parameter matches all input fields of the form
            '*
            '**/
            Public Function createData(formData as <xsl:value-of select="$formName"/>InputData) as ResultCode
                    Dim curData as new <xsl:value-of select="$formName"/>CustomData
                    Set createData = curData.createData(formData)
            End Function

        Public Function createAndReadData(formData as <xsl:value-of select="$formName"/>InputData) as ExtendedResult
                Set createAndReadData = new ExtendedResult
                Set createAndReadData.Data = new <xsl:value-of select="$formName"/>CustomData
                Set createAndReadData.Result = createAndReadData.Data.createData(formData) 
        End Function

        Public Function readData(key as String) as <xsl:value-of select="$formName"/>CustomData
                    Dim tmpResult as new <xsl:value-of select="$formName"/>CustomData
                    Call tmpResult.readData(key)
                    Set readData = tmpResult
            End Function
            
            Public Function updateData(key as String, formData as <xsl:value-of select="$formName"/>InputData) as ResultCode
                    Dim curData as new <xsl:value-of select="$formName"/>CustomData
                    Set updateData = curData.updateData(key, formData)        
            End Function
            
            Public Function updateAndReadData(key as String, formData as <xsl:value-of select="$formName"/>InputData) as ExtendedResult
                    Set updateAndReadData = new ExtendedResult
                    Set updateAndReadData.Data = new <xsl:value-of select="$formName"/>CustomData
                    Set updateAndReadData.Result = updateAndReadData.Data.updateData(key,formData) 
            End Function
            
            Public Function deleteData(key as String) as ResultCode
                Dim curData as new <xsl:value-of select="$formName"/>CustomData
                Set deleteData = curData.deleteData(key)
            End Function
        
        End Class
        
        Public Class ResultCode
            Public Value as Integer 'We use HTTP values
            Public DBid as String
            Public DocID as String
        End Class
        
        Public Class ExtendedResult
            Public Result as ResultCode
            Public Data as <xsl:value-of select="$formName"/>CustomData
        End Class
        
        <xsl:apply-templates select="d:form" />
    </xsl:template>
    
    <xsl:template match="d:form">
        Public Class <xsl:value-of select="$formName"/>Data
        
            Private db as NotesDatabase
            Private s as NotesSession
            Private doc as NotesDocument
            Private curResultCode as ResultCode
            
            'Here are the custom Notes Fields that make the core of this transformation
            <xsl:apply-templates select="//d:field" />
        
            Sub New
                set s = new NotesSession
                set db = s.currentDatabase
                set curResultCode = new ResultCode
                curResultCode.DBid = db.replicaID
            End Sub
        
            Function createData(formData as <xsl:value-of select="$formName"/>InputData) as ResultCode
                    Set doc = new NotesDocument(db)
                    if Fields2Doc(formData) then
                        curResultCode.Value = 200 'Everything worked
                        curResultCode.docID = doc.universalID
                    else
                        curResultCode.Value = 500 'Error
                    end if
                    set createData = curResultCode
            End Function
        
            Function readData(key as String) as <xsl:value-of select="$formName"/>Data
                if getDocument(key) then
                    if Doc2Fields then
                        curResultCode.Value = 200 'Everything worked
                    else
                        curResultCode.Value = 500 'Error
                    end if
                else
                    curResultCode.Value = 404 'Error
                End if
                set readData = Me
            End Function
        
        Function updateData(key as String, formData as <xsl:value-of select="$formName"/>InputData) as ResultCode
            if getDocument(key) then
                if Fields2Doc(formData) then
                    curResultCode.Value = 200 'Everything worked
                else
                    curResultCode.Value = 500 'Error
                 end if
             else
                 curResultCode.Value = 500 'Error
            End if
            Set updateData = curResultCode
            End Function
        
            Function deleteData(key as String) as ResultCode
                if getDocument(key) then
                    call doc.remove(true)
                    curResultCode.Value = 200 'Everything worked
                else
                    curResultCode.Value = 404 'Error
                End if
                Set deleteData = curResultCode
                
            End Function
            
            Private Function Doc2Fields as Boolean
                Dim i as Integer 'Counter for various functions
                <xsl:apply-templates select="//d:field" mode="doc2fields"/>
            End Function
            
            Private Function Fields2Doc(formData as <xsl:value-of select="$formName"/>InputData) as Boolean
                <!-- ToDO: Introduce error handling and error recovery -->
                Dim i as integer 'Counter for various loops
                <xsl:apply-templates select="//d:field" mode="fields2doc"/>
                Call doc.ComputeWithForm(true,false) 'Fixes eventuall data type errors.
                Call doc.Save(true,true)
            End Function
            
            Private Function getDocument(key as String) as Boolean
                set doc = db.getDocumentByUNID(key)
                if doc is nothing then
                    getDocument = false
                    curResultCode.docID = ""
                else
                    curResultCode.docID = doc.universalid
                    getDocument = true
                 end if   
            End Function
        
        End Class
        
        Public Class <xsl:value-of select="$formName"/>InputData
                <xsl:apply-templates select="//d:field" mode="inputdata"/>
        End Class

'/**
'*  The following class is your extension point
'*  The generated code calls the base class/parent class methods
'*  You can add your own stuff here, so separation between generated and hand code is easy
'*  Attention: code gets overwritten when regenerating, so carefull what you cut and paste
'*
'**/
Public Class <xsl:value-of select="$formName"/>CustomData as <xsl:value-of select="$formName"/>Data 
        Sub New
        
        End Sub
        
        Function createData(formData as <xsl:value-of select="$formName"/>InputData) as ResultCode
        Set createData = <xsl:value-of select="$formName"/>Data..createData(formData) 'We call the parent class
        'Your code goes here
        
        End Function

        Function readData(key as String) as <xsl:value-of select="$formName"/>Data
        Set readData = <xsl:value-of select="$formName"/>Data..readData(key)
        'Your code goes here ....
        
        End Function
        
        Function updateData(key as String, formData as <xsl:value-of select="$formName"/>InputData) as ResultCode
        Set updateData = <xsl:value-of select="$formName"/>Data..updateData(key, formData)
        'Your code goes here
        
        End Function

        Function deleteData(key as String) as ResultCode
        'Your code goes here if you want do things before the deletion
        Set deleteData = <xsl:value-of select="$formName"/>Data..deleteData(key)
        'Your code goes here
        
        End Function
        
        End Class
        

    </xsl:template>
    
    <!-- Determin the datatype. This maps Notes field types to XML Datatypes. Change as needed -->
    <xsl:template name="getdatatype">
        <xsl:param name="curField" />
        <xsl:choose>
            <xsl:when test="$curField/@type='text'">XSD_STRING</xsl:when>
            <xsl:when test="$curField/@type='keyword'">XSD_STRING</xsl:when>
            <xsl:when test="$curField/@type='password'">XSD_STRING</xsl:when>
            <xsl:when test="$curField/@type='keyword'">XSD_STRING</xsl:when>
            <xsl:when test="$curField/@type='names'">XSD_STRING</xsl:when>
            <xsl:when test="$curField/@type='authors'">XSD_STRING</xsl:when>
            <xsl:when test="$curField/@type='readers'">XSD_STRING</xsl:when>
            <xsl:when test="$curField/@type='formula'">XSD_STRING</xsl:when>
            <xsl:when test="$curField/@type='number'">XSD_DOUBLE</xsl:when>
            <xsl:when test="$curField/@type='datetime'">XSD_DATETIME</xsl:when>
            <!-- TODO: complete the datatype mapping! -->
            <xsl:otherwise>XSD_ANYTYPE</xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <!-- Fields need to be specified per mode/edit/compute and data type --> 
    <xsl:template match="d:field">
        <xsl:variable name="datatype">
            <xsl:call-template name="getdatatype">
                <xsl:with-param name="curField" select="." />
            </xsl:call-template>
            </xsl:variable>
         Public <xsl:value-of select="@name"/> as <xsl:value-of select="$datatype"/>
    </xsl:template>
    
    <!-- We need to treat multivalue fields a little different since they are arrays -->
    <xsl:template match="d:field[@allowmultivalues='true']">
        <xsl:variable name="datatype">
            <xsl:call-template name="getdatatype">
                <xsl:with-param name="curField" select="." />
            </xsl:call-template>
        </xsl:variable>
        Public <xsl:value-of select="@name"/>() as <xsl:value-of select="$datatype"/>
    </xsl:template>
    
    <!-- Here we copy the XML data into the Notes items -->
    <xsl:template match="d:field" mode="fields2doc">
        <!-- TODO: better data type back matching -->
        Call doc.replaceItemValue("<xsl:value-of select="@name"/>",<xsl:value-of select="@name"/>.getValueAsString)
    </xsl:template>
    
    <xsl:template match="d:field[@allowmultivalues='true']" mode="fields2doc">
        Dim temp_<xsl:value-of select="@name"/>() as Variant
        Redim temp_<xsl:value-of select="@name"/>(Ubound(<xsl:value-of select="@name"/>))
        For i = 0 to Ubound(<xsl:value-of select="@name"/>)
        temp_<xsl:value-of select="@name"/>(i) = <xsl:value-of select="@name"/>(i).getValueAsString 
        Next
        Call doc.replaceItemValue("<xsl:value-of select="@name"/>",<xsl:value-of select="@name"/>)
    </xsl:template>
    
    <!-- This is moving notes items from the document to values in the LS Object -->
    <xsl:template match="d:field" mode="doc2fields">
        <!-- ToDo: complete the field to object mapping (RichText missing)-->
        <xsl:variable name="datatype">
            <xsl:call-template name="getdatatype">
                <xsl:with-param name="curField" select="." />
            </xsl:call-template>
        </xsl:variable>
        Set <xsl:value-of select="@name"/> = new <xsl:value-of select="$datatype"/>
        'Assign the value
        Call <xsl:value-of select="@name"/>.SetValueFromString(doc.getFirstItem("<xsl:value-of select="@name"/>").text)
    </xsl:template>

    <xsl:template match="d:field[@allowmultivalues='true']" mode="doc2fields">
        <!-- ToDo Complete the datatype matching -->
        <xsl:variable name="datatype">
            <xsl:call-template name="getdatatype">
                <xsl:with-param name="curField" select="." />
            </xsl:call-template>
        </xsl:variable>        
         Dim tmp_<xsl:value-of select="@name"/> as Variant
        tmp_<xsl:value-of select="@name"/> = doc.getItemValue("<xsl:value-of select="@name"/>")
        Redim <xsl:value-of select="@name"/>(Ubound(tmp_<xsl:value-of select="@name"/>))
        For i = 0 to Ubound(tmp_<xsl:value-of select="@name"/>)
            Set <xsl:value-of select="@name"/>(i) = new <xsl:value-of select="$datatype"/>
            'Now assign the value
            call <xsl:value-of select="@name"/>(i).SetValueFromString(Cstr(tmp_<xsl:value-of select="@name"/>(i)))
        next
    </xsl:template>
    

    <!-- Define editable data, only editable data will be taken in when creating or updating a document -->
    <xsl:template match="d:field[@kind='editable']" mode="inputdata">
        <xsl:variable name="datatype">
            <xsl:call-template name="getdatatype">
                <xsl:with-param name="curField" select="." />
            </xsl:call-template>
        </xsl:variable>        
        Public <xsl:value-of select="@name"/> as <xsl:value-of select="$datatype"/>
    </xsl:template>
    <xsl:template match="d:field" mode="inputdata" />

    <xsl:template match="d:field[@kind='editable' and @allowmultivalues='true']" mode="inputdata">
        <xsl:variable name="datatype">
            <xsl:call-template name="getdatatype">
                <xsl:with-param name="curField" select="." />
            </xsl:call-template>
        </xsl:variable>        
        Public <xsl:value-of select="@name"/>() as <xsl:value-of select="$datatype"/>
    </xsl:template>
    
    <xsl:template match="d:field" mode="inputdata" />
    
</xsl:stylesheet>
