<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:f="http://www.w3.org/2005/Atom"
    xmlns:app="http://www.w3.org/2007/app" xmlns:snx="http://www.ibm.com/xmlns/prod/sn"
    xmlns:os="http://a9.com/-/spec/opensearch/1.1/" xmlns:xhtml="http://www.w3.org/1999/xhtml"
    xmlns:thr="http://purl.org/syndication/thread/1.0" exclude-result-prefixes="xs" version="2.0">
    
    <xsl:template match="/">

        <html>
            <head>
                <title>Activity entries with custom fields</title>
                <style type="text/css">
                    html, body, td {font-family : Verdana, Arial, sans-serif; font-size : small }
                    th, td {
                        text-align : left;
                        border-right : 1px solid gray ;
                        border-bottom : 1px solid gray ;
                    }</style>
            </head>
            <body>
                <table>
                    <xsl:apply-templates select="//f:entry[snx:field[@type='text']][1]"
                        mode="header"/>
                    <tbody>
                        <xsl:apply-templates select="//f:entry"/>
                    </tbody>

                </table>
            </body>
        </html>

    </xsl:template>

    <xsl:template match="f:entry"/>

    <!-- We presume we have one text field there -->
    <xsl:template match="f:entry[snx:field[@type='text']]">
        <tr>
            <td>
                <xsl:element name="a">
                    <xsl:attribute name="href">
                        <xsl:value-of select="f:link[@rel='self']/@href" />
                    </xsl:attribute>
                <xsl:value-of select="f:title"/>
                </xsl:element>
            </td>
            <xsl:apply-templates select="snx:field" />
        </tr>
    </xsl:template>
    
    <xsl:template match="snx:field[@type='text']">
        <td>
            <xsl:value-of select="f:summary"/>
        </td>
    </xsl:template>
    
    <xsl:template match="snx:field[@type='person']">
        <td>
            <xsl:value-of select="f:name"/>
            (<xsl:value-of select="f:email"/>)
        </td>
    </xsl:template>

    <xsl:template match="f:entry[snx:field[@type='file']]" mode="header"/>
    <xsl:template match="snx:field[@type='file']" mode="header"/>

    <xsl:template match="f:entry[snx:field]" mode="header">
        <thead>
            <tr>
                <th>Title</th>
                <xsl:apply-templates select="snx:field" mode="#current" />
            </tr>
        </thead>
    </xsl:template>

    <xsl:template match="snx:field" mode="header">
        <th>
            <xsl:value-of select="@name" />
        </th>
    </xsl:template>

</xsl:stylesheet>
