/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XSLTHelper {
    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage XSLTHelper SourceFile StyleSheet Result");
            System.exit(1);
        }
        String sourceFileName = args[0];
        String styleFileName = args[1];
        String resultFileName = args.length > 2 ? args[2] : String.valueOf(args[1]) + ".transformed";
        HashMap<String, String> params = new HashMap<String, String>();
        int i = 3;
        while (i < args.length) {
            String parValue;
            String parName;
            int x = args[i].indexOf("=");
            if (x > 1) {
                parName = args[i].substring(0, x);
                parValue = args[i].substring(x + 1);
            } else {
                parName = "Parameter" + Integer.toString(i);
                parValue = args[i];
            }
            System.out.println("Parameter \"" + parName + "\"=[" + parValue + "]");
            params.put(parName, parValue);
            ++i;
        }
        XSLTHelper.transform(sourceFileName, styleFileName, resultFileName, params);
        System.out.println("Transformed " + sourceFileName + " with " + styleFileName + " into " + resultFileName);
    }

    public static void transform(String sourceFileName, String styleFileName, String resultFileName, HashMap<String, String> params) {
        File resultFile;
        File xmlFile = new File(sourceFileName);
        File xsltFile = new File(styleFileName);
        boolean canContinue = true;
        if (!xmlFile.exists()) {
            System.err.println("File is missing: " + sourceFileName);
            canContinue = false;
        }
        if (!xsltFile.exists()) {
            System.err.println("File is missing: " + styleFileName);
            canContinue = false;
        }
        if (!canContinue) {
            System.exit(1);
        }
        if ((resultFile = new File(resultFileName)).exists()) {
            resultFile.delete();
        }
        StreamSource xmlSource = new StreamSource(xmlFile);
        StreamSource xsltSource = new StreamSource(xsltFile);
        StreamResult xmlResult = new StreamResult(resultFile);
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer(xsltSource);
            for (Map.Entry<String, String> curEntry : params.entrySet()) {
                transformer.setParameter(curEntry.getKey(), curEntry.getValue());
            }
            transformer.transform(xmlSource, xmlResult);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

