/*
 * Decompiled with CFR 0.152.
 */
package com.notessensei.cocomo;

import com.notessensei.cocomo.ArtefactResult;
import com.notessensei.cocomo.DomHelper;
import com.notessensei.cocomo.ResourceHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ArtefactExtractor {
    private final String reportFileName;
    private final File rootDir;
    private final Collection<String> tagsForLOC;
    private final Collection<String> xmlExtensions;
    private final Map<String, Set<String>> reportMappings;
    private final Map<String, String> sourceTypes;
    private String commandFileName = null;

    public static String help() {
        return "Usage:java -jar cocomo.jar sourceDir ReportFile [CommandFile]";
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.out.println(ArtefactExtractor.help());
            System.exit(1);
        }
        String sourceDir = ResourceHelper.pathWithSeperator(args[0]);
        String resultFile = args[1];
        File morituri = new File(resultFile);
        if (morituri.exists()) {
            morituri.delete();
        }
        ArtefactExtractor ae = new ArtefactExtractor(sourceDir, resultFile);
        if (args.length > 2) {
            String commandFile = args[2];
            ae.setCommandFile(commandFile);
        }
        ae.extract();
        System.out.println("Done!");
    }

    public void setCommandFile(String commandFile) {
        this.commandFileName = commandFile;
    }

    public ArtefactExtractor(String sourceDir, String resultFileName) {
        this.reportFileName = resultFileName;
        this.rootDir = new File(ResourceHelper.pathWithSeperator(sourceDir));
        this.tagsForLOC = this.populateTagsForLoc();
        this.xmlExtensions = this.populateXmlExtension();
        this.reportMappings = this.populateReportMappings();
        this.sourceTypes = this.populateSourceTypes();
    }

    public void extract() throws IOException {
        if (!this.rootDir.isDirectory()) {
            System.err.println("You need to point to the directory above the On-Disk-Projects!");
            System.exit(1);
        }
        File result = new File(this.reportFileName);
        FileOutputStream out = new FileOutputStream(result);
        PrintWriter pw = new PrintWriter(out);
        this.writeResultHeader(pw);
        if (this.commandFileName != null) {
            Scanner commandScanner = new Scanner(new File(this.commandFileName));
            while (commandScanner.hasNextLine()) {
                File f;
                String nextLine = commandScanner.nextLine().trim();
                if (nextLine.startsWith("#") || nextLine.equals("") || !(f = new File(nextLine)).isDirectory()) continue;
                System.out.println("Working on application: " + f.getName());
                this.analyzeOneApplication(f, pw);
            }
        } else {
            File[] fileArray = this.rootDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory() && !f.getName().startsWith(".")) {
                    System.out.println("Working on application: " + f.getName());
                    this.analyzeOneApplication(f, pw);
                    pw.flush();
                }
                ++n2;
            }
        }
        pw.flush();
        pw.close();
        out.close();
    }

    private void analyzeOneApplication(File appDir, PrintWriter pw) throws FileNotFoundException {
        ArtefactResult result = new ArtefactResult();
        File[] fileArray = appDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File subDir = fileArray[n2];
            if (subDir.isDirectory()) {
                this.scanDirectory(subDir, result);
            }
            ++n2;
        }
        File metrics = new File(String.valueOf(appDir.getAbsolutePath()) + "app.metrics");
        PrintWriter mw = new PrintWriter(new FileOutputStream(metrics));
        mw.write(result.toString());
        mw.flush();
        mw.close();
        pw.write(appDir.getName());
        pw.write(",");
        pw.write(result.getResults(this.reportMappings));
        pw.write("\n");
    }

    private void inspectCodeLine(String inputLine, ArtefactResult result) {
        String workLine = inputLine.trim().toLowerCase();
        for (String curkey : this.sourceTypes.keySet()) {
            if (!workLine.contains(curkey.toLowerCase())) continue;
            result.add(this.sourceTypes.get(curkey));
        }
    }

    private boolean isElementFromTemplate(Element nodeElement) {
        String fromTemplate;
        return nodeElement.hasAttribute("fromtemplate") && !(fromTemplate = nodeElement.getAttribute("fromtemplate")).trim().equals("");
    }

    private void iterateAndCount(Element element, ArtefactResult result, String extension) {
        NodeList nodeList = element.getChildNodes();
        int i = 0;
        int size = nodeList.getLength();
        while (i < size) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                Element nodeElement = (Element)node;
                String curName = node.getNodeName();
                boolean elementIsFromTemplate = this.isElementFromTemplate(nodeElement);
                if (elementIsFromTemplate) {
                    String fromTemplate = nodeElement.getAttribute("fromtemplate");
                    result.add("template_" + fromTemplate);
                    return;
                }
                result.add(curName);
                result.add(String.valueOf(extension) + "_" + curName);
                this.updateLOC(nodeElement, result);
                this.iterateAndCount(nodeElement, result, extension);
            }
            ++i;
        }
    }

    private Map<String, Set<String>> populateReportMappings() {
        TreeMap<String, Set<String>> result = new TreeMap<String, Set<String>>();
        Properties workingProperties = new Properties();
        String propFileName = String.valueOf(this.getClass().getName()) + ".properties";
        File propFile = new File(propFileName);
        boolean success = false;
        if (propFile.exists()) {
            try {
                workingProperties.load(new FileInputStream(propFile));
                success = true;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!success) {
            System.out.println("Using defaults for Report definition:" + propFile.getAbsolutePath());
            InputStream in = this.getClass().getResourceAsStream("defaultReport.properties");
            try {
                workingProperties.load(in);
                in.close();
                workingProperties.store(new FileOutputStream(propFile), "***** Default values ******");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (Map.Entry<Object, Object> entry : workingProperties.entrySet()) {
            String key = entry.getKey().toString();
            String[] rawValues = entry.getValue().toString().split(",");
            TreeSet<String> values = new TreeSet<String>();
            String[] stringArray = rawValues;
            int n = rawValues.length;
            int n2 = 0;
            while (n2 < n) {
                String v = stringArray[n2];
                if (!v.trim().equals("")) {
                    values.add(v.trim());
                }
                ++n2;
            }
            result.put(key, values);
        }
        return result;
    }

    private Map<String, String> populateSourceTypes() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        InputStream in = this.getClass().getResourceAsStream("SourceType.properties");
        Properties workingProperties = new Properties();
        try {
            workingProperties.load(in);
            for (Map.Entry<Object, Object> me : workingProperties.entrySet()) {
                result.put(me.getKey().toString(), me.getValue().toString());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    private Collection<String> populateTagsForLoc() {
        TreeSet<String> result = new TreeSet<String>();
        InputStream in = this.getClass().getResourceAsStream("LocTags.properties");
        Scanner s = new Scanner(in);
        while (s.hasNextLine()) {
            String w = s.nextLine().trim();
            if (w.startsWith("#") || w.equals("")) continue;
            result.add(w);
        }
        return result;
    }

    private Collection<String> populateXmlExtension() {
        TreeSet<String> result = new TreeSet<String>();
        InputStream in = this.getClass().getResourceAsStream("xmlExtensions.properties");
        Scanner s = new Scanner(in);
        while (s.hasNextLine()) {
            String w = s.nextLine().trim();
            if (w.startsWith("#") || w.equals("")) continue;
            result.add(w);
        }
        return result;
    }

    private void scanCodeFile(File f, ArtefactResult result, String extension) throws FileNotFoundException {
        int addLoc = 0;
        int addFunctions = 0;
        Scanner sc = new Scanner(f);
        while (sc.hasNextLine()) {
            String curLine = sc.nextLine().trim().toLowerCase();
            if (curLine.trim().equals("")) continue;
            if (curLine.startsWith("sub") || curLine.startsWith("function") || curLine.startsWith("public class") || curLine.startsWith("public") || curLine.startsWith("private") && curLine.contains("{") || curLine.startsWith("protected") && curLine.contains("{")) {
                ++addFunctions;
            }
            ++addLoc;
        }
        result.add("LOC_" + extension, addLoc);
        result.add("LOC", addLoc);
        result.add("functions_" + extension, addFunctions);
        result.add("functions", addFunctions);
    }

    private void scanDirectory(File subDir, ArtefactResult result) throws FileNotFoundException {
        File[] fileArray = subDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory() && !f.getName().startsWith(".")) {
                this.scanDirectory(f, result);
            } else {
                this.scanOneFile(f, result);
            }
            ++n2;
        }
    }

    private void scanOneFile(File f, ArtefactResult result) throws FileNotFoundException {
        String fname = f.getName();
        int pos = fname.lastIndexOf(".");
        if (pos < 0) {
            return;
        }
        String extension = fname.substring(pos + 1).toLowerCase().trim();
        if (extension.endsWith("metadata")) {
            return;
        }
        result.add("File-" + extension);
        if (fname.equals("database.properties") || this.xmlExtensions.contains(extension)) {
            this.scanXMLFile(f, result, extension);
        } else if (extension.equals("java") || extension.equals("js") || extension.equals("jss") || extension.equals("lss")) {
            this.scanCodeFile(f, result, extension);
        } else if (extension.equals("properties")) {
            this.scanPlainFile(f, result);
        } else {
            result.add("otherFiles");
        }
    }

    private void scanPlainFile(File f, ArtefactResult result) throws FileNotFoundException {
        int addLoc = 0;
        Scanner sc = new Scanner(f);
        while (sc.hasNextLine()) {
            if (sc.nextLine().trim().equals("")) continue;
            ++addLoc;
        }
        result.add("LOC_other", addLoc);
        result.add("LOC", addLoc);
    }

    private void scanXMLFile(File f, ArtefactResult result, String extension) {
        Document xDoc = DomHelper.getDomHelper().file2Dom(f.getPath());
        if (xDoc != null) {
            Element element = xDoc.getDocumentElement();
            this.iterateAndCount(element, result, extension);
        }
    }

    private void updateLOC(Element element, ArtefactResult result) {
        String language = element.getNodeName();
        if (this.tagsForLOC.contains(language)) {
            int addCount = 0;
            NodeList nodeList = element.getChildNodes();
            int i = 0;
            int size = nodeList.getLength();
            while (i < size) {
                Node node = nodeList.item(i);
                if (node.getNodeType() == 3) {
                    BufferedReader source = new BufferedReader(new StringReader(node.getNodeValue()));
                    try {
                        String curLine;
                        while ((curLine = source.readLine()) != null) {
                            String workLine = curLine.trim().toLowerCase();
                            if (workLine.equals("") || workLine.startsWith("'")) continue;
                            this.inspectCodeLine(workLine, result);
                            ++addCount;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
            result.add("LOC", addCount);
            result.add("LOC_" + language, addCount);
        }
    }

    private void writeResultHeader(PrintWriter pw) {
        TreeSet<String> headers = new TreeSet<String>();
        headers.addAll(this.reportMappings.keySet());
        pw.append("Application");
        for (String h : headers) {
            pw.append(",");
            pw.write(h);
        }
        pw.append(",Total");
        pw.write("\n");
    }
}

