/*
 * Decompiled with CFR 0.152.
 */
package com.notessensei.cocomo;

import com.notessensei.cocomo.MagicNamespaceContext;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class DomHelper {
    private static final int FILE_READ_BYTESIZE = 1024;
    private static DomHelper domHelper = null;

    public static final synchronized DomHelper getDomHelper() {
        if (domHelper == null) {
            domHelper = new DomHelper();
        }
        return domHelper;
    }

    private DomHelper() {
    }

    public final synchronized boolean areElementsEqual(Element source, Element target) {
        return this.areElementsEqual(source, target, null);
    }

    public final synchronized boolean areElementsEqual(Element source, Element target, List<String> elemetsToExclude) {
        boolean result = false;
        if (elemetsToExclude != null && elemetsToExclude.contains(source.getNodeName())) {
            return true;
        }
        NamedNodeMap sourceAttributes = source.getAttributes();
        int i = 0;
        while (i < sourceAttributes.getLength()) {
            Node curAttr = sourceAttributes.item(i);
            String curName = curAttr.getNodeName();
            String curVal = curAttr.getNodeValue();
            if (target.hasAttribute(curName)) {
                if (!curVal.equals(target.getAttribute(curName))) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        NamedNodeMap targetAttributes = target.getAttributes();
        int i2 = 0;
        while (i2 < targetAttributes.getLength()) {
            Node curAttr = targetAttributes.item(i2);
            String curName = curAttr.getNodeName();
            if (!source.hasAttribute(curName)) {
                return false;
            }
            ++i2;
        }
        String sourceText = source.getTextContent();
        String targetText = target.getTextContent();
        if (sourceText == null && targetText != null || sourceText != null && targetText == null) {
            return false;
        }
        if (sourceText == null && targetText == null) {
            return true;
        }
        if (sourceText != null && !sourceText.equals(targetText)) {
            return false;
        }
        NodeList sourceChildren = source.getChildNodes();
        NodeList targetChildren = target.getChildNodes();
        if (sourceChildren.getLength() != targetChildren.getLength()) {
            return false;
        }
        int i3 = 0;
        while (i3 < sourceChildren.getLength()) {
            Node curSourceNode = sourceChildren.item(i3);
            Node curTargetNode = targetChildren.item(i3);
            if (curSourceNode.getNodeType() != curTargetNode.getNodeType()) {
                return false;
            }
            if (curSourceNode.getNodeType() == 1 && !this.areElementsEqual((Element)curSourceNode, (Element)curTargetNode, elemetsToExclude)) {
                return false;
            }
            ++i3;
        }
        return result;
    }

    public final synchronized Document createDomDocument() {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.newDocument();
            return doc;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return null;
        }
    }

    public final synchronized void dom2File(Node dom, String outFileName) {
        String stuff = this.dom2String(dom);
        this.string2File(outFileName, stuff);
    }

    public final synchronized String dom2String(Node dom) {
        String result = null;
        StreamResult xResult = null;
        DOMSource source = null;
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            xResult = new StreamResult(new StringWriter());
            source = new DOMSource(dom);
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(source, xResult);
            result = xResult.getWriter().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.stripEmptyLines(result);
    }

    public final synchronized DocumentFragment file2DocumentFragment(Document doc, String fragmentSourceFileName) {
        String fragmentSource = this.file2String(fragmentSourceFileName);
        if (fragmentSource == null) {
            System.err.println("File does not exist: " + fragmentSourceFileName);
            return null;
        }
        return this.string2DocumentFragment(doc, fragmentSource);
    }

    public final synchronized Document file2Dom(String sourceFileName) {
        Document d = null;
        File sourceFile = new File(sourceFileName);
        if (!sourceFile.exists()) {
            System.err.println("No such file: " + sourceFileName);
            return null;
        }
        if (sourceFile.isDirectory()) {
            System.err.println(String.valueOf(sourceFileName) + " is a directory, but must be a file");
            return null;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        InputSource source = null;
        try {
            source = new InputSource(new FileReader(sourceFile));
            DocumentBuilder docb = factory.newDocumentBuilder();
            d = docb.parse(source);
        }
        catch (Exception e) {
            e.printStackTrace();
            d = null;
        }
        if (d == null) {
            System.out.println("DOM from file generation failed:\n" + sourceFile.getAbsolutePath());
        }
        return d;
    }

    public final synchronized String file2String(String inFileName) {
        File inFile = new File(inFileName);
        if (!inFile.exists()) {
            System.err.println("No such file: " + inFileName);
            return null;
        }
        if (inFile.isDirectory()) {
            System.err.println(String.valueOf(inFileName) + " is a directory, but must be a file");
            return null;
        }
        long filesize = inFile.length();
        StringBuffer fileData = new StringBuffer();
        long totalRead = 0L;
        try {
            filesize = inFile.length();
            BufferedReader reader = new BufferedReader(new FileReader(inFile));
            char[] buf = new char[1024];
            int numRead = 0;
            while ((numRead = reader.read(buf)) != -1) {
                totalRead += (long)numRead;
                String readData = String.valueOf(buf, 0, numRead);
                fileData.append(readData);
                buf = new char[1024];
            }
            if (totalRead + 1024L < filesize) {
                System.err.print("File read error, reported size is ");
                System.err.print(filesize);
                System.err.print(" but only read ");
                System.err.println(totalRead);
            } else {
                System.out.print("File " + inFileName + " read:");
                System.out.println(totalRead);
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fileData.toString();
    }

    public final synchronized String getElementString(Element sourceElement) {
        NodeList children;
        String elementName = sourceElement.getTagName();
        StringBuffer result = new StringBuffer();
        if (!elementName.equals("textlist") && !elementName.equals("text")) {
            result.append(elementName);
            result.append(this.getAttributeString(sourceElement.getAttributes()));
        }
        if ((children = sourceElement.getChildNodes()) != null) {
            int i = 0;
            while (i < children.getLength()) {
                Node curNode = children.item(i);
                short nodeType = curNode.getNodeType();
                if (nodeType == 1) {
                    Element curElement = (Element)curNode;
                    result.append(this.getElementString(curElement));
                } else if (nodeType == 3) {
                    result.append(curNode.getNodeValue());
                    result.append("\n");
                }
                ++i;
            }
        }
        char newLine = new String("\n").charAt(0);
        int i = result.length() - 1;
        while (i > 0) {
            char curChar = result.charAt(i);
            char previousChar = result.charAt(i - 1);
            if (newLine == curChar && newLine == previousChar) {
                result.deleteCharAt(i);
            }
            --i;
        }
        return result.toString();
    }

    public final synchronized String removeInvalidCharsFromFileName(String input) {
        StringBuffer b = new StringBuffer();
        b.append(input);
        return this.removeInvalidCharsFromFileName(b);
    }

    public final synchronized String removeInvalidCharsFromFileName(StringBuffer b) {
        String invalidChars = "#%<>{}~:*?\\/|";
        int i = b.length() - 1;
        while (i > 1) {
            char curChar = b.charAt(i);
            if (curChar == File.pathSeparatorChar) {
                b.replace(i, i + 1, File.separator);
            } else if (curChar != File.separatorChar && invalidChars.indexOf(curChar) > -1) {
                b.replace(i, i + 1, "_");
            }
            if (curChar == File.separatorChar && b.charAt(i - 1) == File.separatorChar) {
                b.deleteCharAt(i);
            }
            --i;
        }
        return b.toString();
    }

    public final synchronized DocumentFragment string2DocumentFragment(Document doc, String fragmentSource) {
        String fragment = "<fragment>" + fragmentSource + "</fragment>";
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            InputSource source = new InputSource(new StringReader(fragment));
            Document d = factory.newDocumentBuilder().parse(source);
            Node node = doc.importNode(d.getDocumentElement(), true);
            DocumentFragment docfrag = doc.createDocumentFragment();
            while (node.hasChildNodes()) {
                docfrag.appendChild(node.removeChild(node.getFirstChild()));
            }
            return docfrag;
        }
        catch (SAXException sAXException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public final synchronized Document string2Dom(String sourceString) {
        Document d = null;
        if (sourceString != null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            InputSource source = new InputSource(new StringReader(sourceString));
            try {
                DocumentBuilder docb = factory.newDocumentBuilder();
                d = docb.parse(source);
            }
            catch (Exception e) {
                e.printStackTrace();
                d = null;
            }
        }
        if (d == null) {
            System.out.println("DOM generation failed:\n" + sourceString);
        }
        return d;
    }

    public final synchronized void string2File(String outFileName, String stuff) {
        String sep;
        int max;
        File outFile = new File(outFileName);
        try {
            if (outFile.exists()) {
                if (outFile.isDirectory()) {
                    System.err.print("Output Error: " + outFileName + " is a directory");
                    return;
                }
                outFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ((max = outFileName.lastIndexOf(sep = File.separator)) > 0) {
            String dirName = outFileName.substring(0, max);
            File outDir = new File(dirName);
            outDir.mkdirs();
        }
        BufferedWriter w = null;
        try {
            try {
                w = new BufferedWriter(new FileWriter(outFile));
                w.write(stuff);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (w != null) {
                        w.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (w != null) {
                    w.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public final synchronized void xpath2File(Document doc, String xPathString, String outFileName) {
        this.xpath2File(doc, xPathString, outFileName, null);
    }

    public final synchronized void xpath2File(Document doc, String xPathString, String outFileName, Map<String, String> additionalNamespaces) {
        String xPathResult = this.xpath2String(doc, xPathString, additionalNamespaces);
        this.string2File(outFileName, xPathResult);
    }

    public final synchronized NodeList xpath2NodeList(Document doc, String xPathString) {
        return this.xpath2NodeList(doc, xPathString, null);
    }

    public final synchronized NodeList xpath2NodeList(Document doc, String xPathString, Map<String, String> additionalNamespaces) {
        Object exprResult = null;
        XPath xpath = XPathFactory.newInstance().newXPath();
        MagicNamespaceContext nsc = new MagicNamespaceContext();
        if (additionalNamespaces != null) {
            nsc.addNamespaces(additionalNamespaces);
        }
        xpath.setNamespaceContext(nsc);
        try {
            exprResult = xpath.evaluate(xPathString, doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            System.err.println("XPATH failed for " + xPathString);
            System.err.println(e.getMessage());
        }
        if (exprResult == null) {
            return null;
        }
        NodeList nodes = (NodeList)exprResult;
        return nodes;
    }

    public final synchronized String xpath2String(Document doc, String xPathString) {
        return this.xpath2String(doc, xPathString, null);
    }

    public final synchronized String xpath2String(Document doc, String xPathString, Map<String, String> additionalNamespaces) {
        StringBuffer b = new StringBuffer();
        NodeList nodes = this.xpath2NodeList(doc, xPathString, additionalNamespaces);
        if (nodes == null || nodes.getLength() == 0) {
            System.out.println("XPath had no results:" + xPathString);
            return null;
        }
        System.out.print("XPath found results for: " + xPathString + ": ");
        System.out.println(nodes.getLength());
        int nodeCount = nodes.getLength();
        int i = 0;
        while (i < nodeCount) {
            if (i > 0) {
                b.append("\n");
            }
            Node curNode = nodes.item(i);
            b.append(this.dom2String(curNode));
            ++i;
        }
        return b.toString();
    }

    private String getAttributeString(NamedNodeMap attributes) {
        StringBuffer b = new StringBuffer();
        int max = attributes.getLength();
        if (max == 0) {
            return "";
        }
        b.append(" (");
        int i = 0;
        while (i < max) {
            Node curNode = attributes.item(i);
            String curName = curNode.getNodeName();
            String curValue = curNode.getNodeValue();
            b.append(curName);
            b.append("=");
            b.append(curValue);
            b.append(", ");
            ++i;
        }
        b.append(")");
        return b.toString();
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    private String stripEmptyLines(String inString) {
        StringBuffer b = new StringBuffer();
        Scanner lineScanner = new Scanner(inString);
        while (lineScanner.hasNextLine()) {
            String curLine = lineScanner.nextLine().trim();
            if (curLine.equals("") || curLine.replace("\n", "").equals("")) continue;
            b.append(curLine);
            b.append("\n");
        }
        return b.toString();
    }
}

