/*
 * Decompiled with CFR 0.152.
 */
package com.notessensei.cocomo;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;

public class MagicNamespaceContext
implements NamespaceContext {
    private final Map<String, String> nameSpacesByPrefix = new HashMap<String, String>();
    private final Map<String, Set<String>> nameSpacesByURI = new HashMap<String, Set<String>>();

    public MagicNamespaceContext() {
        this.addNamespace("xml", "http://www.w3.org/XML/1998/namespace");
        this.addNamespace("xmlns", "http://www.w3.org/2000/xmlns/");
        this.addNamespace("", "http://www.lotus.com/dxl");
        this.addNamespace("d", "http://www.lotus.com/dxl");
        this.addNamespace("dxl", "http://www.lotus.com/dxl");
    }

    public synchronized void addNamespace(String prefix, String uri) {
        this.nameSpacesByPrefix.put(prefix, uri);
        if (this.nameSpacesByURI.containsKey(uri)) {
            Set<String> set = this.nameSpacesByURI.get(uri);
            if (!set.contains(prefix)) {
                set.add(prefix);
            }
        } else {
            HashSet<String> set = new HashSet<String>();
            set.add(prefix);
            this.nameSpacesByURI.put(uri, set);
        }
    }

    public synchronized void addNamespaces(Map<String, String> newNamespaces) {
        for (String prefix : newNamespaces.keySet()) {
            this.addNamespace(prefix, newNamespaces.get(prefix));
        }
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (this.nameSpacesByPrefix.containsKey(prefix)) {
            return this.nameSpacesByPrefix.get(prefix);
        }
        return "";
    }

    @Override
    public String getPrefix(String namespaceURI) {
        return this.getPrefixes(namespaceURI).next();
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        Set<String> set = this.nameSpacesByURI.get(namespaceURI);
        if (set == null) {
            return null;
        }
        return set.iterator();
    }
}

