/*
 * Decompiled with CFR 0.152.
 */
package com.notessensei.cocomo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;

public class ResourceHelper {
    public static final int RESOURCE_READ_BYTESIZE = 1024;

    public InputStream resourceToInputStream(String resourceName) {
        InputStream in = null;
        String fullSourcePath = "resources/" + resourceName;
        ArrayList<String> sources = new ArrayList<String>();
        sources.add("*.*");
        sources.add("/*.*");
        sources.add("*.xml");
        sources.add("/resources/*.*");
        sources.add("resources/*.*");
        try {
            for (String r : sources) {
                URL u;
                Enumeration<URL> e = this.getClass().getClassLoader().getResources(r);
                while (e.hasMoreElements()) {
                    u = e.nextElement();
                    System.out.println(u.toString());
                }
                e = ClassLoader.getSystemResources(r);
                while (e.hasMoreElements()) {
                    u = e.nextElement();
                    System.out.println(u.toString());
                }
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        in = this.getClass().getResourceAsStream(fullSourcePath);
        if (in == null) {
            System.out.println("Resource not found:" + fullSourcePath);
            return null;
        }
        return in;
    }

    public String resourceToString(String resourceName) {
        StringBuffer b = new StringBuffer();
        InputStream in = null;
        try {
            in = this.resourceToInputStream(resourceName);
            if (in != null) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                char[] buf = new char[1024];
                int numRead = 0;
                while ((numRead = reader.read(buf)) != -1) {
                    String readData = String.valueOf(buf, 0, numRead);
                    b.append(readData);
                    buf = new char[1024];
                }
                reader.close();
                in.close();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return b.toString();
    }

    public static String pathWithSeperator(String source) {
        char delimiter = File.separatorChar;
        if (source.charAt(source.length() - 1) != delimiter) {
            return String.valueOf(source) + File.separator;
        }
        return source;
    }

    public boolean resourceToFileSystem(String targetDirectory, String resourceName) {
        boolean result = true;
        String fullTargetPath = String.valueOf(targetDirectory) + File.separator + resourceName;
        InputStream in = null;
        FileOutputStream out = null;
        try {
            in = this.resourceToInputStream(resourceName);
            out = new FileOutputStream(fullTargetPath);
            byte[] buffer = new byte[4096];
            int n = 0;
            while (-1 != (n = in.read(buffer))) {
                ((OutputStream)out).write(buffer, 0, n);
            }
            in.close();
            ((OutputStream)out).close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            result = false;
        }
        catch (IOException e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }
}

